import sys
import PyQt5.QtCore
import PyQt5.QtGui
from PyQt5.QtGui import QMouseEvent, QPainter, QPen, QBrush, QColor
from PyQt5.QtWidgets import *
from PyQt5.QtGui import QIcon
from PyQt5.QtCore import QObject, Qt
import axioma.gui.extension
import axioma.app
from axioma.cs import CoordTransform
from axioma.gui import RibbonId, Tool

'''
Показ статистики по землятрясениям. Функция доступна, если открыто окно с картой.
Для корректного просмотра информации рекомендуется открыть карту world.
По нажатию на кнопку производится запрос на сайт USGS. Результат показыввается в окне карты.
'''

class EarthquakeCoordinates(Tool):
    def __init__(self, parent=None):
        super().__init__(parent)
        self.__points, self.__magnitudes = get_points()
        # сконвертировать точки, если это необходимо
        # to make convert point if it is necessary
        transform = CoordTransform(axioma.app.csfactory.LatLongCoordSystem(), self.widget().viewport().coordSystem())
        self.__points = transform.forward(self.__points)
        self.widget().coordSystemChanged.connect(self.coordSysAboutToChange)
        self.__coordsys = self.widget().viewport().coordSystem()

    def paintEvent(self, event, painter):
        painter.setPen(QPen(Qt.NoPen))
        painter.setBrush(QBrush(QColor(255, 0, 0, 64)))
        devicePoints = self.getDevicePoints()
        for i in range(len(devicePoints)):
            radius = 3 * self.__magnitudes[i]
            painter.drawEllipse(devicePoints[i], radius, radius)
        return

    def getDevicePoints(self):
        """Получить координаты точек области рисования"""
        """Retrieve coords of points for draw area"""
        try:
            return [self.widget().viewport().mapToDevice(point) for point in self.__points]
        except Exception as ex:
            print(ex)

    def coordSysAboutToChange(self):
        """Действия перед сменой проекции"""
        """Actions before changing projection"""
        try:
            # сконвертируем точки в новую проекцию
            # convert points to new CoordSystem
            if not len(self.__points):
                return
            newCS = self.widget().viewport().coordSystem()
            transform = CoordTransform(self.__coordsys, newCS)
            self.__points = transform.forward(self.__points)
            self.__coordsys = newCS
        except:
            pass

import json
import urllib.request
from PyQt5.QtCore import QPointF

def get_points():
    '''Получить координаты и силу землетрясений'''
    '''Get coordinates and earthquake power during 1 week'''
    # Запросить все землетрясения за неделю >= 4.5 балла
    # Get all earthquakes during one week with magneture >= 4.5
    link = "http://earthquake.usgs.gov/earthquakes/feed/v1.0/summary/4.5_week.geojson"
    with urllib.request.urlopen(link) as response:
        data = json.loads(response.read().decode('utf-8'))

    points = []
    mags = []

    for feature in data['features']:
        properties = feature['properties']
        magnitude = properties['mag']
        # time = properties['time']
        geometry = feature['geometry']
        coordinates = geometry['coordinates']
        points.append(QPointF(coordinates[0], coordinates[1]))
        mags.append(magnitude)
    return points, mags

translateDict = {"caption" : {"ru" : 'Модуль "Землетрясения"', "en" : "Earthquake module"},
                 "name" : {"ru" : "Землетрясения", "en" : "Earthquakes"},
                 "module" : {"ru" : "Пример модуля", "en" : "Module examples"}}

def trans(mess):
    return translateDict[mess][axioma.app.core.translationLanguage()]

def getPluginExtensions():
    ribbonExt = axioma.gui.extension.RibbonExtension()
    ribbonExt.addAction("pluginAxiomaEarthquake", "ExamplePluginTab", "ExampleEarthQuakeGroupId")
    ribbonExt.addTab("ExamplePluginTab", trans("module"))
    ribbonExt.addGroup("ExamplePluginTab","ExampleEarthQuakeGroupId", trans("caption"))
    toolExt = axioma.gui.extension.BasicToolExtension(EarthquakeCoordinates, axioma.gui.MapView, "pluginAxiomaEarthquake", icon=QIcon.fromTheme("bufferZone"), text=trans("caption"))
    return [ribbonExt, toolExt]
