import os
from PyQt5.QtWidgets import QWidget
from PyQt5.QtCore import QStringListModel
from axioma.core.dp import DataCatalog, Table, Raster, FileDefinition
from PyQt5.uic import loadUi

class DataCatalogInfoWidget(QWidget):
    """
    Класс отображения информации каталоге данных
    """

    def __init__(self, mainWindow=None):
        super().__init__(mainWindow)
        cwd = os.path.dirname(__file__)
        self.__ui = loadUi(os.path.join(cwd, "datacatalog_info_widget.ui"), self)
        self.__datacatalog = mainWindow.dataCatalog()
        self.__datacatalog.updated.connect(self.onUpdated)
        self.__filesModel = QStringListModel()
        self.__ui.filesList.setModel(self.__filesModel)
        self.onUpdated()

    # SLOTS
    def onUpdated(self):
        sources = self.__datacatalog.allDataSources()
        objects = self.__datacatalog.allDataObjects()

        table_count = len([obj for obj in objects if isinstance(obj, Table)])
        raster_count = len([obj for obj in objects if isinstance(obj, Raster)])

        def file_filter(source):
           definition = source.dataSourceDefinition()
           if isinstance(definition, FileDefinition):
               return definition

        file_defs = [file_filter(s) for s in sources]
        file_names = [fd.filename() for fd in file_defs]

        self.__filesModel.setStringList(file_names)
        self.__ui.cntTable.setNum(table_count)
        self.__ui.cntRaster.setNum(raster_count)
