from axioma.render import *
from axioma.mapinfo import MapBasicStyle
from axioma.core.plugin import *

'''
Определение класса геометрии по стилю и занесение его как элемента в CollectionStyle.
'''

# Создаем стиль из строки MapBasic
style = MapBasicStyle().styleFromString("Brush (8,16776960,16777215) Pen (1,2,0)")
# Через менеджер расширений получаем нужное расширение для заданного стиля
styleExt = axioma.app.render.geometryStyleManager().styleExtensionByStyle(style)
print('Тип геометрии={}, Стиль геометрии={}'.format(styleExt.geometryStyleClassId(), styleExt.styleId()))
# Создаем CollectionStyle и заносим в него созданный стиль для площадных объектов
coll = CollectionStyle()
coll.setStyle(styleExt.geometryStyleClassId(), style)
   
'''
Как альтернатива данному подходу, данный сервис можно получить как результат посторения зависимости. Это удобно использовать 
в пользовательских расширениях. Рассмотрим аналогичное решение.

# Объявляем класс-расширение для получения менеджера стилей
class MyExtension(axioma.core.plugin.Extension):
    def __init__(self):
        super().__init__()
        self.geometryStyleManager = self.createDependencyGetter(axioma.render.GeometryStyleManager)

# Создаем расширение как объект и регистрируем его в системе
ext = MyExtension()
axioma.app.render.prependExtension(ext)

# Запрашиваем менеджер
if ext.geometryStyleManager is not None:
   # Создаем стиль из строки MapBasic
   style = MapBasicStyle().styleFromString("Brush (8,16776960,16777215) Pen (1,2,0)")
   # Через менеджер расширений получаем нужное расширение для заданного стиля
   styleExt = ext.geometryStyleManager().styleExtensionByStyle(style)
   print('Тип геометрии={}, Стиль геометрии={}'.format(styleExt.geometryStyleClassId(), styleExt.styleId()))
   # Создаем CollectionStyle и заносим в него созданный стиль для площадных объектов
   coll = CollectionStyle()
   coll.setStyle(styleExt.geometryStyleClassId(), style)

'''
   