# Пример кода для открытия и редактирования таблицы с помощью JSON 
from axioma.core.dp import *
from axioma.cs import *
from axioma.core.geometry import *
from axioma.render import *
from axioma.common import RuntimeException
from axioma.mapinfo import *
import axioma.core
from PyQt5.QtCore import *
from PyQt5.QtGui import *

'''
Пример вставки объекта в таблицу и сохранение информации об изменениях.
При занесении информации до вызова commit используется файл транзакций.
'''

# Открываем таблицу
json = {
    "src": "/tmp/world.tab"
}
table = axioma.core.open_json(json)
if table is None:
    raise RuntimeException("Таблица не открыта")
assert(isinstance(table, TransactionalTable))
axioma.app.mainWindow.registerDataObject(table)

# Определяем индексы изменяемых полей
index_geometry = table.tableSchema().geometryIndex()
index_style = table.tableSchema().styleIndex()
index_country = table.tableSchema().indexOf('Country')

# Вставка
new_feature = Feature.createFeature(table.tableSchema())
# Устанавливаем геометрию по индексу поля
poly = QPolygonF();
v = 1000000
poly << QPointF(-v, -v) << QPointF(-v, v) << QPointF(v, v) << QPointF(v, -v) << QPointF(-v, -v)
polygon = Polygon(table.coordSystem(), poly)
new_feature.setAttribute(index_geometry, polygon)
new_feature.setModified(index_geometry, True)
new_feature.setAttribute(index_country, 'New Country')
new_feature.setModified(index_country, True)
style = MapBasicStyle().styleFromString('Pen (1,2,0) Brush (2, 65280, 16777215)')
new_feature.setAttribute(index_style, style)
new_feature.setModified(index_style, True)

# Вставка в транзакционную таблицу
table.insert([new_feature])

table.commit()



