
import axioma
from axioma.core import open_json
import axioma.core.geometry as gm
from axioma.gui import ProgressSpec, showLongWait


def user_heavy_function(progressHandler, json):
    """
    Пример пользовательской функции выполняющей длительные вычисления
    """
    table = open_json(json)
    features = table.allFeatures()  
    index_geo = table.tableSchema().geometryIndex()
    result = []
    # Устанавливаем границы изменения прогресса
    progressHandler.setProgressRange(0, len(features))
    progress = 0
    for feature in features: 
        # Тут мы проверяем не отменил ли пользователь операцию через интерфейс
        if progressHandler.isCanceled():
            return
        geom = feature.getAttribute(index_geo)
        if not gm.isValid(geom):
            geom = gm.normalizedGeometry(geom)
        result.append(gm.ConvexHull(geom))
        progress +=1
        # Управляем прогрессом, отсылая текущее значение
        progressHandler.setProgress(progress)
        # Меняем основное сообщение диалога
        progressHandler.setMessage(" Номер текущей геометрии {}".format(progress + 1))
    return result
    

json = {"src": "path/to/tab_file_name.TAB"}
spec = ProgressSpec()
spec.parent = axioma.app.mainWindow
spec.windowTitle = "Получаем минимальный окаймляющий полигон"
spec.dialogType = ProgressSpec.ProgressDialog
result = showLongWait(spec, user_heavy_function, json)
print(result)
