from typing import List, Optional
from .data_provider import DataProvider
from .source import Source, Destination, Schema
from ..attribute_schema import Schema


class SqliteSource(Source):
    pass


class SqliteDataProvider(DataProvider):
    """Векторный провайдер sqlite."""
    _identifier = 'SqliteDataProvider'

    def get_source(self, filepath: str, dataobject: Optional[str] = None, sql: Optional[str] = None) -> Source:
        """Создает источник данных. В качестве объекта может быть указана либо таблица, либо текст запроса.
        Если указан `sql`, то он имеет более высокий приоритет по отношению к значению `dataobject`.
        Если оба параметра опущены, будет возвращен None.

        Args:
            filepath: Путь к файлу.
            dataobject: Имя таблицы.
            sql: SQL-запрос.

        Пример с таблицей::

            table = provider_manager.openfile('world.sqlite', dataobject='world')

        Пример с запросом::

            table = provider_manager.openfile('world.sqlite', sql="select * from world where Страна like 'Р%'")
        """
        return SqliteSource(
            Source._provider(self.id),
            Source._table_file(filepath),
            {'dataobject': dataobject, 'sql': sql}
        )

    def get_destination(self) -> Destination:
        """
        Attention:
            Не поддерживается.
        """
        raise NotImplementedError
