"""Модуль отрисовки.

Данный модуль содержит инструменты, предназначенные для отрисовки
геопространственных и прочих данных.
"""

from axipy.cpp_render import Render

from .context import Context
from .layer import Layer, VectorLayer, Label, RasterLayer, ListThematic, ThematicLayer
from .thematic_layer import (RangeThematicLayer, create_range,
                             AllocationThematic,
                             OrientationThematic,
                             StyledByIndexThematic,
                             PieThematicLayer, create_pie,
                             BarThematicLayer,
                             SymbolThematicLayer,
                             IndividualThematicLayer,
                             DensityThematicLayer, 
                             ReallocateThematicColor)
from .map import Map, ListLayers
from .report import (Report, ReportItem,
                     GeometryReportItem, MapReportItem, RasterReportItem, TableReportItem,
                     LegendReportItem, ScaleBarReportItem, ReportItems)
from .legend import Legend, LegendItem, ListLegendItems


# fix sphinx inheritance and typehints
from axipy._util import fixup_module_metadata
fixup_module_metadata(__name__, globals())
del fixup_module_metadata
