from axipy import *
from PySide2.QtWidgets import QAction
from PyQt5.QtCore import QTimer


class Plugin:
    def __init__(self, iface):
        self.action = None
        self.menu = None
        self.notifications = iface.notifications
        self.timer = QTimer()
        self.timer.setInterval(1000)
        self.timer.start()
        self.timer.timeout.connect(self.init_menu)

    def init_menu(self):
        from axipy.app import mainwindow
        if mainwindow.is_valid:
            actName = "TmsDataProviderMenuAction"
            actions = mainwindow.qt_object().findChildren(QAction, actName)
            if (len(actions)):
                self.menu = actions[0].menu()
                self.action = self.menu.addAction('Публичная кадастровая карта')
                self.action.triggered.connect(self.show_map)
                self.timer.stop()
            else:
                print('Действие {} не найдено'.format(actName))

    def unload(self):
        if self.action is not None:
            self.menu.removeAction(self.action)

    def show_map(self):
        self.notifications.push ('Предупреждение', 'Отрисовка данных кадастровой карты на некоторых масштабах может производиться с временной задержкой.')

        rest_raster = provider_manager.rest.open('https://pkk.rosreestr.ru/arcgis/rest/services/PKK6/CadastreObjects/MapServer')
        rest_raster.name = 'rosreestr'
        rest_layer = Layer.create(rest_raster)
        rest_layer.zoom_restrict = True
        rest_layer.max_zoom = 3000
        rest_layer.title = 'Крупный масштаб'

        sputnik_raster = provider_manager.tms.open('http://tiles.maps.sputnik.ru/{LEVEL}/{ROW}/{COL}.png?apikey=1xjIfiBwnаX8', watermark="<a href='http://maps.sputnik.ru/'>Спутник</a> © Ростелеком © Openstreetmap")
        sputnik_raster.name = 'sputnik'
        sputnik_layer = Layer.create(sputnik_raster)
        sputnik_layer.title = 'Подложка'

        rr_raster = provider_manager.tms.open('https://pkk.rosreestr.ru/arcgis/rest/services/Hosted/caddivsion/VectorTileServer/tile/{LEVEL}/{COL}/{ROW}.pbf', size=(1024, 1024))
        rr_raster.name = 'rosreestr_large'
        rr_layer = Layer.create(rr_raster)
        rr_layer.zoom_restrict = True
        rr_layer.min_zoom = 3000
        rr_layer.title = 'Мелкий масштаб'

        map = Map([ rest_layer, rr_layer, sputnik_layer ])
        mapview = view_manager.create_mapview(map)
        k = mapview.device_rect.width / mapview.device_rect.height
        center = Pnt(4188000, 7510000)
        half_zoom = 5000 / 2
        half_height = half_zoom / k
        mapview.scene_rect = Rect(center.x - half_zoom, center.y - half_height, center.x + half_zoom, center.y + half_height)
