from itertools import chain
from PySide2.QtCore import QRectF, Qt
from PySide2.QtWidgets import QToolTip, QInputDialog
from axipy.cs import CoordTransformer
from axipy.da import Geometry, Type, Point
from axipy.da import GEOMETRY_ATTR
from axipy.render import VectorLayer
from axipy.gui import MapTool


class MyTool(MapTool):
    def __init__(self):
        super().__init__()
        self.attr_index = 0
    
    def mousePressEvent(self, event) -> bool:
        if event.button() == Qt.LeftButton:
            self.show_tooltip(event)
        elif event.button() == Qt.RightButton:
            i, ok = QInputDialog.getInt(None, 'Параметры', 'Выберите номер атрибута:',
                self.attr_index, 0)
            if ok:
                self.attr_index = i
        return self.PassEvent

    def mouseReleaseEvent(self, event) -> bool:
        """Blocks right click context menu."""
        return self.BlockEvent

    def show_tooltip(self, event) -> None:
        scene_box = self.get_select_rect(event.pos())
        tables = self.get_tables()
        feature_iters = map(lambda table: self.get_features(table, scene_box), tables)
        features = chain.from_iterable(feature_iters)
        text = ', '.join(str(feature[self.attr_index]) for feature in features)
        QToolTip.showText(event.globalPos(), text)

    def get_tables(self):
        for layer in self.view.map.layers:
            if not isinstance(layer, VectorLayer):
                continue
            yield layer.data_object

    def get_features(self, table, scene_box):
        if table.coordsystem != self.view.coordsystem:
            transformer = CoordTransformer(self.view.coordsystem, table.coordsystem)
            scene_box = transformer.transform(scene_box)
        center = scene_box.center
        scene_point = Point(center.x, center.y, table.coordsystem)
        for feature in table.items(bbox=scene_box):
            geometry = feature[GEOMETRY_ATTR]
            if geometry.type == Type.Point or geometry.contains(scene_point):
                yield feature
