from PySide2.QtSql import QSqlDatabase
from axipy.cpp_gui import ShadowGui
from axipy.cpp_core_dp import ShadowDataCatalog


class GuiClass:
    def __init__(self):
        self._shadow = None

    @property
    def shadow(self):
        if not self._shadow:
            from axipy.gui import gui_instance_shadow as instance
            if not instance:
                raise RuntimeError("axipy is not initialized")
            self._shadow = instance
        return self._shadow

    def _is_initialized(self):
        try:
            from axipy.gui import gui_instance_shadow
        except ImportError:
            return False
        return True

    def _initialize(self):
        self._shadow = ShadowGui.create()
        self._shadow.initialize()

    def database(self) -> QSqlDatabase:
        return self.shadow.database()

    def _cpp_catalog(self) -> ShadowDataCatalog:
        return self.shadow.catalog()


gui_instance = GuiClass()
