from axipy.cpp_core_dp import Converter
from typing import List
from .data_provider import DataProvider
from .source import Source, Destination, Schema
from ..attribute_schema import Schema


class MifMidDestination(Destination):
    pass


class MifMidDataProvider(DataProvider):
    """Провайдер данных MIF-MID."""
    _identifier = 'MifMidDataProvider'

    def get_source(self) -> Source:
        """
        Attention:
            Не поддерживается.

            Поддерживает экспорт только в TAB. См. :meth:`convert_to_tab`.
        """
        raise NotImplementedError

    def get_destination(self, filepath: str, schema: Schema) -> Destination:
        """Создает назначение объекта данных.

        Args:
            filepath: Путь к файлу.
            schema: Схема таблицы.
        """
        return MifMidDestination(schema,
                                 Source._provider(self.id),
                                 Source._table_file(filepath),
                                 )

    def convert_to_tab(self, mif_filepath: str, tab_filepath: str):
        """Конвертирует из MIF в TAB.

        Args:
            mif_filepath: Путь к исходному файлу.
            tab_filepath: Путь к выходному файлу.
        """
        mif_source = MifMidDestination(Schema(),
                                       Source._provider(self.id),
                                       Source._table_file(mif_filepath),
                                       {'access': 'ro'}
                                       )
        tab_dest = MifMidDestination(
            Schema(),
            Source._provider('TabDataProvider'),
            Source._table_file(tab_filepath)
        )
        Converter.convertMifToTab(mif_source, tab_dest)
