import types
import axioma.app
from axioma.common import RuntimeException
from axioma.gui import WidgetManagerService
from PyQt5.QtWidgets import QWidget
from PyQt5.QtCore import QObject

if axioma.app.gui:
	# get instance
	widgetManager = axioma.app.gui.widgetManagerService()

	# connections
	widgetManager.__currentConnections = dict()

	def activeWidget(self, widget_type=QWidget):
		if not issubclass(widget_type, QWidget):
			raise TypeError("widget_type should be of type QWidget or derived")
		return self.activeWidget_hidden(widget_type.staticMetaObject)

	def connect_widget(widget, unbounded_signal, slot):
		# connect slot to widget's signal
		# return bounded signal
		bounded = unbounded_signal.__get__(widget)
		bounded.connect(slot)
		return bounded

	def onContextDestroyed(self, context):
		# remove connections
		for connection in self.__currentConnections[context]:
			if connection["bound"]:
				# disconnect current connections
				try:
					connection["bound"].disconnect(connection["slot"])
				except:
					pass
				connection["bound"] = None
		del self.__currentConnections[context]

	def connectCurrentWidget(self, widgetType, unbound_signal, context, callback):
		if context and not isinstance(context, QObject):
			raise TypeError("context should be of type QObject or None")
		current_widget = self.activeWidget(QWidget)
		bounded = None if not isinstance(current_widget, widgetType) else connect_widget(current_widget, unbound_signal, callback)
		new_connection = {"type":widgetType, "signal":unbound_signal, "bound":bounded, "slot":callback}
		# add connection
		if context in self.__currentConnections:
			self.__currentConnections[context].append(new_connection)
		else:
			self.__currentConnections[context] = [new_connection,]
		# connection life time control
		if context:
			context.destroyed.connect(lambda obj, context=context: self.onContextDestroyed(context))

	def onCurrentWidgetChanged(self, widget):
		try:
			# remove old connection
			for connection_list in self.__currentConnections.values():
				for connection in connection_list:
					# disconnect
					if connection["bound"]:
						try:
							connection["bound"].disconnect(connection["slot"])
						except:
							pass
						connection["bound"] = None
					if isinstance(widget, connection["type"]):
						# establish new connection if instance
						connection["bound"] = connect_widget(widget, connection["signal"], connection["slot"])
		except Exception as ex:
			print(ex)

	# inject
	widgetManager.activeWidget = types.MethodType(activeWidget, widgetManager)
	widgetManager.onContextDestroyed = types.MethodType(onContextDestroyed, widgetManager)
	widgetManager.connectCurrentWidget = types.MethodType(connectCurrentWidget, widgetManager)
	widgetManager.onCurrentWidgetChanged = types.MethodType(onCurrentWidgetChanged, widgetManager)
	widgetManager.connectWidgetChanged(QWidget, None, widgetManager.onCurrentWidgetChanged)
	axioma.app.gui.widgetManager = widgetManager
