import os.path
import axioma.core
from axioma.core.dp import FileDataProvider, TabFileParser, Table, Raster, TableProperties, RasterProperties
from axioma.common import RuntimeException
import warnings

warnings.simplefilter("once")

def open_file(filename):
    warnings.warn('Функция open_file устарела. Используйте аналог axioma.core.open_json', DeprecationWarning, stacklevel=2)
    if not isinstance(filename, str):
        raise RuntimeException("Passed argument must be of type str")
    ext = os.path.splitext(filename)[1][1:].strip().lower()
    data_providers = axioma.app.core.dataProviders()
    # filter file dataproviders
    file_providers = [file_dp for file_dp in data_providers if isinstance(file_dp, FileDataProvider)]
    # open file with first dataprovider that supports given extension
    for provider in file_providers:
        if len(provider.fileTypeCategories().categoriesForExtension(ext)):
            data_source = provider.quickOpenFile(filename)
            res = data_source.openDataObject()
            #set properties from tab file
            if (ext == 'tab'):
                if res.properties() is None:
                    parser = TabFileParser()
                    parser.parse(filename)
                    if (isinstance(res, Table)):
                        res.setProperties(TableProperties(parser.metadata(), parser.tabFile().absoluteFilePath()))
                    if (isinstance(res, Raster)):
                        res.setProperties(RasterProperties(parser.metadata(), parser.tabFile().absoluteFilePath()), parser.rasterLayerProperties())
            return res
    raise RuntimeException("Could not open file: %s" % filename)

