import os
from PySide2.QtWidgets import QDialog, QDialogButtonBox
from PySide2.QtUiTools import QUiLoader

from .CoordinateProcess import *
from axipy import *


class LoadPointsDialog(QDialog):

    def __init__(self, iface) -> None:
        super().__init__(iface.window())
        self.__tr = iface.tr
        uiFile = os.path.join(os.path.dirname(__file__), "LoadPointsDialog.ui")
        self.__ui = QUiLoader().load(uiFile, self)
        self.__load_ui()

    def __load_ui(self):
        for t in data_manager.tables:
            if len(t.schema) >= 4:
                self.__ui.cbTables.addItem(t.name)
        self.__ui.buttonBox.button(QDialogButtonBox.Ok).setEnabled(self.__ui.cbTables.count())
        self.__ui.cbTables.currentIndexChanged.connect(self.__tablesIndexChanged)
        self.__ui.cbTypeData.currentIndexChanged.connect(self.__typeDataIndexChanged)
        if self.__ui.cbTables.count():
            self.__tablesIndexChanged(0)
        self.__typeDataIndexChanged(0)

    def __typeDataIndexChanged(self, idx):
        if idx == 0:
            self.__ui.lblValue1.setText(self.__tr('Х координата:'))
            self.__ui.lblValue2.setText(self.__tr('Y координата:'))
        else:
            self.__ui.lblValue1.setText(self.__tr('Расстояние (м.):'))
            self.__ui.lblValue2.setText(self.__tr('Азимут (град.):'))

    def __set_items(self, cb, attrs, attr):
        cb.clear()
        cb.addItems(attrs)
        cb.setCurrentText(attr)

    def __tablesIndexChanged(self, idx):
        t = self.result_table()
        if t is not None:
            attrs = t.schema.attribute_names
            self.__set_items(self.__ui.cbGeometryId, attrs, CoordinateProcess.IdFeatureField)
            self.__set_items(self.__ui.cbGeometryPartId, attrs, CoordinateProcess.IdGeometryField)
            self.__set_items(self.__ui.cbPointNumber, attrs, CoordinateProcess.IdPointField)
            self.__set_items(self.__ui.cbValue1, attrs, CoordinateProcess.ValueFirstField)
            self.__set_items(self.__ui.cbValue2, attrs, CoordinateProcess.ValueSecondField)

    def result_sql_text(self):
        # Результирующий SQL запрос
        def __ct( cb):
            return cb.currentText() 
        return 'select {}, {}, {}, {}, {} from {} order by 1, 2, 3'.format(__ct(self.__ui.cbGeometryId), __ct(self.__ui.cbGeometryPartId),
            __ct(self.__ui.cbPointNumber), __ct(self.__ui.cbValue1), __ct(self.__ui.cbValue2), self.result_table().name)

    def result_table(self):
        # Результирующая базовая таблица
        return data_manager.find(self.__ui.cbTables.currentText())

    def is_simple_coordinates(self):
        return self.__ui.cbTypeData.currentIndex() == 0

    def exec(self):
        return self.__ui.exec()
        
