from PySide2.QtWidgets import QMessageBox
from axipy import AxiomaPlugin, Position


class Plugin(AxiomaPlugin):
    def load(self):
        tr = self.tr
        self.__action = self.create_action(tr('Пример действия'),
               icon=self.local_file('ui', 'run.png'), on_click=self.show_message)
        position = Position(tr('Основные'), tr('Команды'))
        position.add(self.__action, size=2)
        self.__action_custom = self.create_action(tr('Диалог'),
                icon=self.local_file('ui', 'dialog.png'), on_click=self.show_custom)
        position.add(self.__action_custom, size=2)

    def unload(self):
        self.__action.remove()
        self.__action_custom.remove()

    def show_message(self):
        QMessageBox.information(None, self.tr('Сообщение'),
                self.tr('Пример выполнения действия по нажатию кнопки'))

    def show_custom(self):
        from .helper import create_dialog
        ui_file = self.local_file('ui', 'CustomDialog.ui')
        dialog = create_dialog(ui_file)
        def print_func(): print(dialog.textEdit.toPlainText())
        dialog.btnPrint.clicked.connect(print_func)
        dialog.exec()
