#!/usr/bin/python
# -*- coding: <encoding name> -*-

import sys
import PyQt5.QtCore
from PyQt5.QtCore import QCoreApplication
import PyQt5.QtGui
from PyQt5.QtGui import QMouseEvent, QPainter, QPen
from PyQt5.QtWidgets import *
from PyQt5.QtGui import QIcon
from PyQt5.QtCore import QObject, Qt
import axioma.gui.extension
from axioma.cs import CoordTransform
from axioma.gui import RibbonId, Tool
from enum import Enum

class PanState(Enum):
        no = 1
        prepare = 2
        active = 3

# Пример инструмента, который рисует на карте точки
# An example tool which draws points on a map
class ExampleTool(Tool):
    def __init__(self, widget):
        super().__init__(widget)
        self.__points = []
        self.panState = PanState.no

    def paintEvent(self, event, painter):
        if self.panState == PanState.active:
            return
        if self.panState == PanState.prepare:
            self.panState = PanState.active
        try:
            painter.setPen(QPen(Qt.red, 5, Qt.SolidLine))
            for point in self.getDevicePoints():
                painter.drawPoint(point)
        except:
            pass

    def mouseDoubleClickEvent(self, event):
        try:
            self.__points.clear()
            self.widget().update()
        except:
            pass
        finally:
            return Tool.PassEvent

    def mouseReleaseEvent(self, event):
        pass
        if event.button() == Qt.MiddleButton:
            self.panState = PanState.no
        return Tool.PassEvent

    def mousePressEvent(self, event):
        try:
            if event.button() == Qt.MiddleButton:
                self.panState = PanState.prepare
                return
            if event.button() != Qt.LeftButton:
                return
            self.addPoint(event.pos())
            self.widget().update()
        except:
            pass
        finally:
            return Tool.PassEvent

    def addPoint(self, point):
        try:
            # добавить новую точку
            # преобразовать координату точки области рисования в координату на карте
            # append new point
            # transform coordinate of point on device into coordinate one on map
            scene_point = self.widget().viewport().mapToScene(point)
            self.__points.append(scene_point)
        except:
            pass

    def getDevicePoints(self):
        """Получить координаты точек области рисования"""
        """Get coordinates of all device points"""
        try:
            return [self.widget().viewport().mapToDevice(point) for point in self.__points]
        except:
            return []

class ExampleActionExtension(axioma.gui.NativeActionExtension):
    def __init__(self, action_id, ribbon_action_info, parent=None):
        super().__init__(action_id, ribbon_action_info, parent)
        self.mainwindow = self.createDependencyGetter(axioma.app.MainWindow)
        
    def createAction_impl(self, parent):
        action = PyQt5.QtWidgets.QAction(parent)
        action.setText(QCoreApplication.translate("ru.axioma-gis.pluginexample","Пример действия"))
        action.setIcon(QIcon(":/icons/share/32px/run3.png"))
        action.triggered.connect(self.slot);
        return action
        
    def slot(self):
        QMessageBox.information(self.mainwindow(), QCoreApplication.translate("ru.axioma-gis.pluginexample","Сообщение!"), QCoreApplication.translate("ru.axioma-gis.pluginexample","Пример выполнения действия по нажатию кнопки"))


def createMyExtensions():
    # Расширение, которое добавлят вкладку и группу кнопок в ленточный интерфейс Аксиомы.ГИС
    # Extension to append new tab and grop of buttons into ribbon of Axioma.GIS
    ribbonExt = axioma.gui.extension.RibbonExtension()
    ribbonExt.addTab("ExamplePluginTab", QCoreApplication.translate("ru.axioma-gis.pluginexample","Пример модуля"))
    ribbonExt.addGroup("ExamplePluginTab","ExampleGroupId", QCoreApplication.translate("ru.axioma-gis.pluginexample","Команды модуля"))
    ribbonExt.addCategory("ExamplePluginCategory", QCoreApplication.translate("ru.axioma-gis.pluginexample","Пример модуля"))
    # Задаём размер 2x2 ячейки
    # Set size of cell as 2x2
    ribbonExt.addAction("ExampleActionId", "ExamplePluginTab", "ExampleGroupId",rowSpan=2, columnSpan=2)
    ribbonExt.addAction("ExampleToolId", "ExamplePluginTab", "ExampleGroupId")

    # Расширение, добавляющее QAction, создаваемое функцией createAction
    # Extension to add QAction created by createAction function
    actionExt = ExampleActionExtension("ExampleActionId", axioma.gui.RibbonActionInfo("ExamplePluginCategory", "", ""))
    # Расширение, добавляющее инструмент класса ExampleTool, который работает с виджетами типа axioma.gui.MapView
    # Extension to add ExampleTool tool to process with axioma.gui.MapView witgets
    toolExt = axioma.gui.extension.BasicToolExtension(ExampleTool, axioma.gui.MapView, "ExampleToolId", icon=QIcon("://icons/share/32px/notification_critical.png"), text=QCoreApplication.translate("ru.axioma-gis.pluginexample","Пример инструмента"))

    return [ribbonExt, actionExt, toolExt]
