from .data_provider import DataProvider, Table
from .source import Source, Destination, Schema
from typing import List, Optional


class TmsSource(Source):
    pass


class TmsDataProvider(DataProvider):
    """Провайдер для тайловых серверов.
    """
    _identifier = 'TmsDataProvider'

    def get_source(self, templateUrl: str, minLevel: int = 0, maxLevel: int = 19, size: tuple = (256, 256), watermark: str ='') -> Source:
        """ Создает источник данных
        templateUrl: Шаблон для запроса данных. Например, `http://tiles.maps.sputnik.ru/{LEVEL}/{ROW}/{COL}.png`
        minLevel: Минимальный уровень показа
        maxLevel: Максимальный уровень показа
        size: размер тайлов
        watermark: Ссылка на правообладателя
        """
        return TmsSource(
            Source._provider(self.id),
            {
                'src': templateUrl,
                'minLevel' : minLevel,
                'maxLevel' : maxLevel,
                'tileSize': '{}x{}'.format(size[0], size[1]),
                'watermarkText': watermark
            }
        )

  